## Requirements

### Installation

Install PyTorch based on your CUDA version:

```bash
# CUDA 11.8
pip install torch==2.2.2 torchvision==0.17.2 torchaudio==2.2.2 --index-url https://download.pytorch.org/whl/cu118

# CUDA 12.1
pip install torch==2.2.2 torchvision==0.17.2 torchaudio==2.2.2 --index-url https://download.pytorch.org/whl/cu121

# CPU only
pip install torch==2.2.2 torchvision==0.17.2 torchaudio==2.2.2 --index-url https://download.pytorch.org/whl/cpu
```

Install additional Python package:

```bash
pip install argparse
pip install numpy
```

### Generate Dataset

```sh
python BS_generator.py
python Heston_generator.py
```
Datasets will be stored in `'Data'`


## Training Scripts

### Adversarial Training on Black-Scholes Model

```bash
python BS_train_adv.py --N 10000 --delta 0.1 --alpha 1.0
```

### Clean Training on Black-Scholes Model

```bash
python BS_train_clean.py --N 10000
```

### Adversarial Training on Heston Model

```bash
python Heston_train_adv.py --N 10000 --delta 0.1 --alpha 1.0 --attack_method 'S'
```

### Clean Training on Heston Model

```bash
python Heston_train_clean.py --N 10000
```

### Input Arguments

* `N`: Number of samples.
* `delta`: Perturbation magnitude of the adversarial attack (applicable only to adversarial training).
* `alpha`: Parameter alpha in Equation (5.1) (applicable only to adversarial training).
* `attack_method`: `'S'` for S-Attack or `'SV'` for SV-Attack (applicable only to adversarial training on the Heston model).

### Outputs

In each script, we partition the training dataset into smaller subsets with sizes N, so 100000/N neural networks are independently trained on these subsets.
The state dictionaries of the trained networks are saved to the `Result` directory for later evaluation. 

## Evaluation

Guidance on assessing network performance on a given dataset are provided in the following notebooks:

* **Black-Scholes Model**: `src/BS_evaluation.ipynb`
* **Heston Model**: `src/Heston_evaluation.ipynb`

## Distributionally Adversarial Attack

In `src/Heston_att.ipynb`, we provide guidance for performing distributionally adversarial attacks as well as comparing autocorrelation functions (ACF) and covariance differences between perturbed and original data as described in Section 5.1 and Appendix E.1.





